var tabla;

function init() {
    $("#rol_form").on("submit", function(e) {
        guardaryeditar(e);
    });
}

$(document).ready(function() {
    tabla = $("#rol_tabla").dataTable({
        "aProcessing": true,
        "aServerSide": true,
        dom: 'Bfrtip',
        buttons: ['copyHtml5', 'excelHtml5', 'csvHtml5'],
        ajax: {
            url: "../../controladores/rol.php?op=listar",
            type: "get",
            dataType: "json",
            error: function(e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "responsive": true,
        "bInfo": true,
        "iDisplayLength": 10,
        "order": [[0, "asc"]],
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix": "",
            "sSearch": "Buscar:",
            "sUrl": "",
            "sInfoThousands": ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    }).DataTable();
});

function guardaryeditar(e) {
    e.preventDefault();
    var formData = new FormData($("#rol_form")[0]);
    $.ajax({
        url: "../../controladores/rol.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos) {
            $("#rol_form")[0].reset();
            $("#modalmtnrol").modal("hide");
            tabla.ajax.reload(function() {
                swal({
                    title: "Sistema Modular QR",
                    text: "Completado.",
                    type: "success",
                    confirmButtonClass: "btn-success"
                });
            });
        },
        error: function(xhr, ajaxOptions, thrownError) {
            console.log(xhr.responseText);
        }
    });
}

function editar(N_rolID) {
    $.post(
        "../../controladores/rol.php?op=mostrar",
        { N_rolID: N_rolID },
        function(data) {
            data = JSON.parse(data);
            $("#N_rolID").val(data.N_rolID);
            $("#Sdescrip").val(data.Sdescrip);
            $("#Cest_rol").val(data.Cest_rol);
        }
    );
    $("#mdltitulo").html("Editar Registro");
    $("#modalmtnrol").modal("show");
}

$(document).on("click", "#btnnuevo", function() {
    $("#mdltitulo").html("Nuevo Registro");
    $("#modalmtnrol").modal("show");
    $("#rol_form")[0].reset();
    $("#N_rolID").val("");
});

init();
