<?php
// Asegúrate de incluir config.php para que $base_url esté disponible
require_once("../../config/config.php");
?>

<header class="site-header">
    <div class="container-fluid">
        <a href="#" class="site-logo">
            <img class="hidden-md-down" src="<?= $base_url; ?>/publico/img/logoPrecor.jpg" alt="">
            <img class="hidden-lg-up" src="<?= $base_url; ?>/publico/img/precorlogo.jpg" alt="">
        </a>

        <button id="show-hide-sidebar-toggle" class="show-hide-sidebar">
            <span>toggle menu</span>
        </button>

        <button class="hamburger hamburger--htla">
            <span>toggle menu</span>
        </button>

        <div class="site-header-content">
            <div class="site-header-content-in">
                <div class="site-header-shown">

                    <div class="dropdown user-menu">
                        <button class="dropdown-toggle" id="dd-user-menu" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php
                            // Ejemplo de asignación de imágenes por rol
                            $rolID = $_SESSION['N_rolID']; // Asumiendo que el rol se guarda en la sesión
                            $rolImg = '';

                            // Cambia las rutas y los nombres de archivos según tus necesidades
                            switch ($rolID) {
                                case 1:
                                    $rolImg = '../../img/dark.png';
                                    break;
                                case 2:
                                    $rolImg = '../../img/storm.png';
                                    break;
                                case 3:
                                    $rolImg = '../../img/rd2d.png';
                                    break;
                                default:
                                    $rolImg = '../../img/storm.png'; 
                                    break;
                            }
                            ?>
                            <img src="<?= $base_url; ?>/publico/img/roles/<?= $rolImg ?>" alt="Icono del Rol">
                        </button>
                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dd-user-menu">
                            <a class="dropdown-item" href="#" onclick="mostrarAyuda()">
                                <span class="font-icon glyphicon glyphicon-question-sign"></span>Ayuda
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="../logout/logout.php"><span class="font-icon glyphicon glyphicon-log-out"></span>Cerrar Sesion</a>
                        </div>
                    </div>
                </div>
                <script type="text/javascript">
                    function mostrarAyuda() {
                        swal({
                            title: "Soporte",
                            text: "Si presenta algun problema, comuniquese con el equipo de TI enviando un correo a soporteti@pmp.com.pe",
                            icon: "info",
                            button: "Aceptar"
                        });
                    }
                </script>

                <div class="mobile-menu-right-overlay"></div>

                <input type="hidden" id="user_idx" value="<?php echo $_SESSION["Ccod_usu"] ?>"><!-- ID del Usuario-->
                <input type="hidden" id="rol_idx" value="<?php echo $rolID ?>"><!-- Rol del Usuario-->

                <div class="dropdown dropdown-typical">
                    <a href="#" class="dropdown-toggle no-arr">
                        <span class="font-icon font-icon-user"></span>
                        <span class="lblcontactonomx">
                            <?php
                            echo isset($_SESSION['Ccod_usu']) ? $_SESSION['Ccod_usu'] : 'ID desconocido';
                            echo " - ";
                            echo isset($_SESSION['Sdescrip']) ? $_SESSION['Sdescrip'] : 'Rol desconocido';
                            ?>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</header>