<?php
require_once("../../config/conexion.php");
// Asegúrate de que la sesión esté iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica si el usuario ha iniciado sesión
if (isset($_SESSION["Ccod_usu"])) {

?>
    <!DOCTYPE html>
    <html>
    <?php require_once("../head/head.php") ?>
    <title>Gestor de Clientes</title>

    </head>

    <body class="with-side-menu">

        <?php require_once("../header/header.php") ?>

        <div class="mobile-menu-left-overlay"></div>
        <?php require_once("../nav/nav.php") ?>

        <div class="page-content">
            <div class="container-fluid">
                <header class="section-header">
                    <div class="tbl">
                        <div class="tbl-row">
                            <div class="tbl-cell">
                                <h2>Registro de Clientes</h2>
                                <h6>En esta ventana, podrás visualizar, registrar y editar datos relacionados a los clientes.</h6>
                                <p></p>
                                <ol class="breadcrumb breadcrumb-simple">
                                    <li><a href="../home/home.php">Inicio</a></li>
                                    <li class="active">Registro de Clientes</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </header>
                <div class="box-typical box-typical-padding">
                    <table id="cliente_tabla" class="display table table-bordered" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th class="d-none d-sm-table-cell" style="width: 5%;">ID del Cliente</th>
                                <th class="d-none d-sm-table-cell" style="width: 10%;">Contacto</th>
                                <th class="d-none d-sm-table-cell" style="width: 10%;">Empresa</th>
                                <th class="d-none d-sm-table-cell" style="width: 10%;">RUC</th>
                                <th class="d-none d-sm-table-cell" style="width: 5%;">Estado</th>
                                <th class="d-none d-sm-table-cell" style="width: 7%;">Fecha de registro</th>
                                <th class="d-none d-sm-table-cell" style="width: 7%;">Fecha de mod.</th>
                                <th class="text-center" style="width: 5%;">Editar</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>

                    <button id="btnnuevo" type="button" class="btn btn-rounded btn-inline btn-primary">Nuevo Cliente</button>

                </div>
            </div><!--.container-fluid-->
        </div><!--.page-content-->

        <?php require_once("modalmtn.php") ?>
        <?php require_once("../js/js.php") ?>

        <script type="text/javascript" src="mtncliente.js"></script>

    </body>

    </html>
<?php
} else {
    header("Location:" . Conectar::ruta() . "index.php");
}
?>