<?php
require_once("../../config/conexion.php");
require_once("../../config/config.php");

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (isset($_SESSION["Ccod_usu"])) {
?>

    <!DOCTYPE html>
    <html lang="es">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Detalle del Activo</title>
        <?php require_once("../head/head.php"); ?>
        <script>
            var baseURL = "<?php echo $base_url; ?>";
        </script>
    </head>

    <body>
        <div class="page-content">
            <div class="container-fluid">
                <section class="box-typical box-typical-padding">
                    <header class="box-typical-header">
                        <h3>Seleccionar Activo</h3>
                    </header>
                    <div class="box-typical-body">
                        <div class="form-group">
                            <label for="Ccod_serieID">Seleccione un Activo:</label>
                            <select id="Ccod_serieID" class="form-control"></select>

                        </div>
                        <div class="form-group text-center">
                            <button id="btnVerActivo" class="btn btn-primary">Ver Activo</button>
                            <button id="btnGenerarQR" class="btn btn-secondary">Generar QR</button>
                            <a href="../anexo/index.php" target="_blank" class="btn btn-info">Repositorio</a>
                        </div>

                        <!-- Contenedor para mostrar el QR generado -->
                        <div id="qr-container" class="form-group text-center" style="display: none;">
                            <h5>QR Generado:</h5>
                            <img id="qr-image" src="" alt="QR Code" style="max-width: 200px; display: none;">
                            <br>
                            <a id="qr-download" href="#" download class="btn btn-success" style="display: none;">Descargar QR</a>
                        </div>
                        <a href="../activo/index.php" target="_blank" class="btn btn-success">Volver</a>
                    </div>
                </section>
            </div>
        </div>

        <?php require_once("../js/js.php"); ?>
        <script src="activo_cliente.js"></script>
    </body>

    </html>

<?php
} else {
    header("Location:" . Conectar::ruta() . "ahspst.php");
    exit();
}
?>