function init() {
  configurarCamposPorRol($("body").data("rol"));
  $("#activo_form").on("submit", guardaryeditar);
  cargarCombos();
  listar();

  $("#btnRefrescarCombos").on("click", cargarCombos);

  $("#Ccod_centroID").on("change", function () {
    let centroID = $(this).val();
    if (centroID) {
      cargarZonasPorCentro(centroID);
    } else {
      limpiarCombo("#Ccod_zonaID");
    }
  });

  $(document).on("click", "#btnnuevo", function () {
    limpiarFormulario();
    cargarCombos();
    $("#Ccod_serieID").val("");
    $("#mdltitulo").html("Nuevo Activo");
    configurarBotonGuardar();
    $("#modalmtnactivo").modal("show");
  });
}

function configurarBotonGuardar() {
  var rol = $("body").data("rol");
  if (rol >= 1 && rol <= 4) {
    $("#activo_form button[type='submit']").prop("disabled", false);
  } else {
    $("#activo_form button[type='submit']").prop("disabled", true);
  }
}

function cargarCombos() {
  cargarCombo(
    "#Ccod_tipo_actID",
    "../../controladores/activo.php?op=combo_tipo_activo"
  );
  cargarCombo(
    "#Ccod_clieID",
    "../../controladores/activo.php?op=combo_clientes"
  );
  cargarCombo(
    "#Ccod_matID",
    "../../controladores/activo.php?op=combo_materiales"
  );
  cargarCombo(
    "#Ccod_centroID",
    "../../controladores/activo.php?op=combo_centros"
  );
  cargarCombo("#Ccod_estID", "../../controladores/activo.php?op=combo_estados");
}

function cargarCombo(selector, url) {
  $.post(url, function (data) {
    $(selector).html(data).trigger("change");
    refrescarSelect(selector);
  }).fail(function () {
    console.error(`Error al cargar datos para ${selector}`);
    limpiarCombo(selector, "-- Error al cargar datos --");
  });
}

function cargarZonasPorCentro(centroID, callback) {
  $.post(
    "../../controladores/activo.php?op=combo_zonas_por_centro",
    { Ccod_centroID: centroID },
    function (data) {
      $("#Ccod_zonaID").html(data).trigger("change");
      refrescarSelect("#Ccod_zonaID");

      if (typeof callback === "function") {
        callback();
      }
    }
  ).fail(function () {
    console.error("Error al cargar zonas para el centro seleccionado.");
    limpiarCombo("#Ccod_zonaID", "-- Error al cargar zonas --");
  });
}

function refrescarSelect(selector) {
  if ($(selector).hasClass("select2")) {
    $(selector).select2();
  } else if ($(selector).hasClass("selectpicker")) {
    $(selector).selectpicker("refresh");
  }
}

function limpiarCombo(selector, mensaje = "-- Seleccione --") {
  $(selector).html(`<option value=''>${mensaje}</option>`).trigger("change");
  refrescarSelect(selector);
}

function listar() {
  tabla = $("#activo_tabla").DataTable({
    aProcessing: true,
    aServerSide: true,
    dom: "Bfrtip",
    buttons: ["copyHtml5", "excelHtml5", "csvHtml5"],
    ajax: {
      url: "../../controladores/activo.php?op=listar",
      type: "get",
      dataType: "json",
      error: function (e) {
        console.error(e.responseText);
      },
    },
    bDestroy: true,
    responsive: true,
    bInfo: true,
    iDisplayLength: 10,
    order: [[0, "asc"]],
    language: {
      sProcessing: "Procesando...",
      sLengthMenu: "Mostrar _MENU_ registros",
      sZeroRecords: "No se encontraron resultados",
      sEmptyTable: "Ningún dato disponible en esta tabla",
      sInfo:
        "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
      sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
      sSearch: "Buscar:",
      oPaginate: {
        sFirst: "Primero",
        sLast: "Último",
        sNext: "Siguiente",
        sPrevious: "Anterior",
      },
    },
  });
}

function editar(Ccod_serieID) {
  $.post(
    "../../controladores/activo.php?op=mostrar",
    { Ccod_serieID: Ccod_serieID },
    function (data) {
      try {
        data = JSON.parse(data);
        $("#Ccod_serieID").val(data.Ccod_serieID);
        $("#Ccod_serie").val(data.Ccod_serie);
        $("#Cdesc_Seri").val(data.Cdesc_Seri);
        $("#Ccod_clieID")
          .val(data.Ccod_clieID || "")
          .trigger("change");
        $("#Ccod_matID").val(data.Ccod_matID).trigger("change");
        $("#Ccod_estID").val(data.Ccod_estID).trigger("change");
        $("#Ccod_centroID").val(data.Ccod_centroID).trigger("change");

        if (data.Ccod_centroID) {
          cargarZonasPorCentro(data.Ccod_centroID, function () {
            $("#Ccod_zonaID").val(data.Ccod_zonaID).trigger("change");
          });
        } else {
          limpiarCombo("#Ccod_zonaID");
        }

        $("#Ccod_tipo_actID").val(data.Ccod_tipo_act).trigger("change");
        $("#Dult_ret").val(data.Dult_ret);
        $("#Dult_desp").val(data.Dult_desp);
        $("#Dult_mnt").val(data.Dult_mnt);
        $("#Dult_rep").val(data.Dult_rep);
        $("#Stiem_ant").val(data.Stiem_ant);
      } catch (error) {
        console.error("Error en la respuesta del servidor:", error);
      }
    }
  );
  $("#mdltitulo").html("Editar Activo");
  configurarBotonGuardar();
  $("#modalmtnactivo").modal("show");
}

function limpiarFormulario() {
  $("#activo_form")[0].reset();
  limpiarCombo("#Ccod_clieID");
  limpiarCombo("#Ccod_matID");
  limpiarCombo("#Ccod_estID");
  limpiarCombo("#Ccod_centroID");
  limpiarCombo("#Ccod_zonaID");
  limpiarCombo("#Ccod_tipo_actID");
}

function guardaryeditar(e) {
  e.preventDefault();

  // Sincronizar los valores de los selects a sus campos hidden antes de enviar el formulario
  $("#Ccod_clieID_hidden").val($("#Ccod_clieID").val() || null);
  $("#Ccod_matID_hidden").val($("#Ccod_matID").val() || null);
  $("#Ccod_estID_hidden").val($("#Ccod_estID").val() || null);
  $("#Ccod_centroID_hidden").val($("#Ccod_centroID").val() || null);
  $("#Ccod_zonaID_hidden").val($("#Ccod_zonaID").val() || null);
  $("#Ccod_tipo_actID_hidden").val($("#Ccod_tipo_actID").val() || null);

  var formData = new FormData($("#activo_form")[0]);

  $.ajax({
    url: "../../controladores/activo.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (response) {
      try {
        var datos = JSON.parse(response);
        if (datos.status === "success") {
          $("#activo_form")[0].reset();
          $("#modalmtnactivo").modal("hide");
          tabla.ajax.reload();
          swal("Completado", "Operación realizada con éxito", "success");
        } else if (datos.status === "duplicate") {
          swal(
            "Número de serie duplicado",
            "El Número de serie ya existe. Corrige el código para continuar.",
            "error"
          );
        } else {
          swal(
            "Error",
            datos.message || "Ocurrió un error al guardar los datos.",
            "error"
          );
        }
      } catch (e) {
        console.error("Error en la respuesta del servidor:", e, response);

        // Detectar errores específicos de claves foráneas y duplicados
        if (response.includes("foreign key constraint fails")) {
          if (response.includes("`activo_ibfk_2`")) {
            swal(
              "Campos vacíos",
              "El campo Material está vacío. Revise el campo y seleccione un material.",
              "warning"
            );
          } else if (response.includes("`activo_ibfk_6`")) {
            swal(
              "Campos vacíos",
              "El campo Tipo de activo está vacío. Revise el campo y seleccione un tipo de activo",
              "warning"
            );
          }
        } else if (response.includes("Duplicate entry")) {
          swal(
            "Número de serie duplicado",
            "El Número de serie ya existe. Corrige el código para continuar.",
            "error"
          );
        } else {
          swal(
            "Error",
            "Respuesta inesperada del servidor. Por favor, revisa los datos y vuelve a intentarlo.",
            "error"
          );
        }
      }
    },
    error: function (xhr, status, error) {
      console.error(`Error: ${status} - ${error}`);
      swal("Error", "Ocurrió un error al intentar guardar los datos.", "error");
    },
  });
}

$(function () {
  $(".datetimepicker-1").datetimepicker({
    format: "YYYY-MM-DD HH:mm:ss",
    showClose: true,
    showClear: true,
    toolbarPlacement: "top",
    widgetPositioning: {
      horizontal: "right",
      vertical: "auto",
    },
  });
});

function configurarCamposPorRol(rol) {
  const configuraciones = {
    1: { readOnly: false, aplicarEstilo: false }, // TI
    2: { readOnly: false, aplicarEstilo: false }, // Administrador
    3: {
      readOnly: true,
      aplicarEstilo: true,
      excepcion: ["#Cdesc_Seri", "#Ccod_clieID", "#Ccod_tipo_actID"],
    }, // Comercial
    4: {
      readOnly: true,
      aplicarEstilo: true,
      excepcion: [
        "#Ccod_serie",
        "#Cdesc_Seri",
        "#Ccod_clieID",
        "#Ccod_estID",
        "#Ccod_centroID",
        "#Ccod_zonaID",
        "#Stiem_ant",
      ],
    }, // Almacen
    5: { readOnly: false, aplicarEstilo: false }, // Operaciones
  };

  const config = configuraciones[rol] || {
    readOnly: true,
    aplicarEstilo: true,
  };

  $("input, select").each(function () {
    const selector = `#${$(this).attr("id")}`;

    if (config.excepcion && config.excepcion.includes(selector)) {
      $(this).prop("readonly", false).removeClass("select-disabled");
    } else {
      $(this).prop("readonly", config.readOnly);

      if (config.aplicarEstilo && config.readOnly) {
        $(this).addClass("select-disabled");
      } else {
        $(this).removeClass("select-disabled");
      }
    }
  });
}

init();
