<?php
class Permiso extends Conectar
{
    public function get_permisos_por_rol($N_rolID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT p.Ctab_per, p.Catrib_per, p.Ctipo_per
                FROM permiso p
                INNER JOIN rol_permiso rp ON p.Npermi_ID = rp.Npermi_ID
                WHERE rp.N_rolID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->execute([$N_rolID]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_permisos()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT p.Npermi_ID, p.Ctab_per, p.Catrib_per, p.Ctipo_per, 
                       r.Sdescrip as rol_descripcion 
                FROM permiso p
                INNER JOIN rol_permiso rp ON p.Npermi_ID = rp.Npermi_ID
                INNER JOIN rol r ON rp.N_rolID = r.N_rolID";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function insert_permiso($Ctab_per, $Catrib_per, $Ctipo_per, $N_rolID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql_permiso = "INSERT INTO permiso (Ctab_per, Catrib_per, Ctipo_per) VALUES (?, ?, ?)";
        $stmt = $conectar->prepare($sql_permiso);
        $stmt->execute([$Ctab_per, $Catrib_per, $Ctipo_per]);

        $Npermi_ID = $conectar->lastInsertId();

        $sql_rol_permiso = "INSERT INTO rol_permiso (N_rolID, Npermi_ID) VALUES (?, ?)";
        $stmt = $conectar->prepare($sql_rol_permiso);
        $stmt->execute([$N_rolID, $Npermi_ID]);

        return true;
    }

    public function get_permiso_by_id($Npermi_ID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT p.Npermi_ID, p.Ctab_per, p.Catrib_per, p.Ctipo_per, 
                       rp.N_rolID 
                FROM permiso p
                INNER JOIN rol_permiso rp ON p.Npermi_ID = rp.Npermi_ID
                WHERE p.Npermi_ID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->execute([$Npermi_ID]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function update_permiso($Npermi_ID, $Ctab_per, $Catrib_per, $Ctipo_per, $N_rolID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql_permiso = "UPDATE permiso SET Ctab_per = ?, Catrib_per = ?, Ctipo_per = ? WHERE Npermi_ID = ?";
        $stmt = $conectar->prepare($sql_permiso);
        $stmt->execute([$Ctab_per, $Catrib_per, $Ctipo_per, $Npermi_ID]);

        $sql_rol_permiso = "UPDATE rol_permiso SET N_rolID = ? WHERE Npermi_ID = ?";
        $stmt = $conectar->prepare($sql_rol_permiso);
        $stmt->execute([$N_rolID, $Npermi_ID]);

        return true;
    }

    public function delete_permiso($Npermi_ID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql_rol_permiso = "DELETE FROM rol_permiso WHERE Npermi_ID = ?";
        $stmt = $conectar->prepare($sql_rol_permiso);
        $stmt->execute([$Npermi_ID]);

        $sql_permiso = "DELETE FROM permiso WHERE Npermi_ID = ?";
        $stmt = $conectar->prepare($sql_permiso);
        $stmt->execute([$Npermi_ID]);

        return true;
    }

    public function get_atributos($tabla)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "DESCRIBE $tabla";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_tablas()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SHOW TABLES";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_roles()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT N_rolID, Sdescrip FROM rol";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>
