<?php
class Graficos extends Conectar
{
    private $conectar;

    public function __construct()
    {
        $this->conectar = parent::conexion();
        parent::set_names();
    }

    public function getTotalActivos()
    {
        $sql = "SELECT COUNT(*) AS total FROM activo";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getActivosSinCliente()
    {
        $sql = "SELECT COUNT(*) AS total FROM activo WHERE Ccod_clieID IS NULL";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getActivosEnMantenimiento()
    {
        $sql = "SELECT COUNT(*) AS total FROM activo WHERE Ccod_estID = 3";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getActivosEnCentro()
    {
        $sql = "SELECT COUNT(*) AS total FROM activo WHERE Ccod_centroID IS NOT NULL";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getActivosPorEstado()
    {
        $sql = "SELECT estado.Edescrip, COUNT(activo.Ccod_estID) AS total 
                FROM activo 
                JOIN estado ON activo.Ccod_estID = estado.Ccod_estID 
                GROUP BY estado.Edescrip";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getActivosPorCentro()
    {
        $sql = "
            SELECT 
                COALESCE(c.Sdesc_centro, 'Fuera de planta') AS Sdesc_centro,
                COUNT(*) AS total
            FROM activo a
            LEFT JOIN centro c ON a.Ccod_centroID = c.Ccod_centroID
            GROUP BY COALESCE(c.Sdesc_centro, 'Fuera de planta')
            ORDER BY total DESC";

        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
