<?php
class AnexoArchivos extends Conectar
{
    public function listar()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM anexo_archivos";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function insertar($Ccod_serieID, $Ccod_usuID, $Cruta_hist, $Cnomb_arch, $C_categ)
    {
        try {
            $conectar = parent::conexion();
            parent::set_names();
            $Dfech_crea = date("Y-m-d");
            $sql = "INSERT INTO anexo_archivos (Ccod_serieID, Ccod_usuID, Cruta_hist, Cnomb_arch, C_categ, Dfech_crea) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = $conectar->prepare($sql);
            $stmt->bindValue(1, $Ccod_serieID);
            $stmt->bindValue(2, $Ccod_usuID);
            $stmt->bindValue(3, $Cruta_hist);
            $stmt->bindValue(4, $Cnomb_arch);
            $stmt->bindValue(5, $C_categ);
            $stmt->bindValue(6, $Dfech_crea);
            $stmt->execute();
            return $stmt->rowCount();
        } catch (PDOException $e) {
            error_log("Error en la inserción: " . $e->getMessage());
            return 0;
        }
    }

    public function get_activos()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM activo";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_categorias()
    {
        return ['interior_exterior', 'pruebas_tecnicas', 'devolucion', 'Imagen QR'];
    }

    public function get_anexos_por_categoria_y_activo($C_categ, $Ccod_serieID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT a.*, u.Ccod_usu 
                FROM anexo_archivos a 
                LEFT JOIN usuario u ON a.Ccod_usuID = u.Ccod_usuID 
                WHERE a.C_categ = ? AND a.Ccod_serieID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $C_categ);
        $stmt->bindValue(2, $Ccod_serieID);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_usuario_id_por_codigo($Ccod_usu)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT Ccod_usuID FROM usuario WHERE Ccod_usu = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $Ccod_usu);
        $stmt->execute();
        return $stmt->fetchColumn();
    }

    public function obtener_ruta_archivo($Historial_ID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT Cruta_hist FROM anexo_archivos WHERE Historial_ID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $Historial_ID);
        $stmt->execute();
        return $stmt->fetchColumn();
    }

    public function eliminar($Historial_ID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "DELETE FROM anexo_archivos WHERE Historial_ID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->bindValue(1, $Historial_ID);
        $stmt->execute();
        return $stmt->rowCount();
    }
}
?>
