<?php
class ActivoCliente extends Conectar
{
    private $conectar;

    public function __construct()
    {
        $this->conectar = parent::conexion();
        parent::set_names();
    }

    public function get_activos()
    {
        $sql = "SELECT Ccod_serieID, Ccod_serie, Cdesc_Seri FROM activo";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function get_activo_detalle($Ccod_serieID)
    {
        $sql = "SELECT a.Ccod_serie, 
                       a.Cdesc_Seri, 
                       IFNULL(c.RUC_clie, 'Cliente no asignado') AS RUC_clie, 
                       ta.Cruta_act
                FROM activo a
                LEFT JOIN cliente c ON a.Ccod_clieID = c.Ccod_clieID
                INNER JOIN tipo_activo ta ON a.Ccod_tipo_act = ta.Ccod_tipo_actID
                WHERE a.Ccod_serieID = ?";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_serieID]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            $result['Cruta_act'] = str_replace('../', '', $result['Cruta_act']);
        }

        return $result;
    }
}
