<?php
require_once("../config/conexion.php");
require_once("../modelos/Ubicacion.php");

$ubicacion = new Ubicacion();

switch ($_GET["op"]) {
    case "listar_historial":
        $datos = $ubicacion->get_ubicaciones();
        $data = [];

        foreach ($datos as $row) {
            $sub_array = [];
            $sub_array[] = $row["Ccod_serie"];
            $sub_array[] = $row["Sdesc_centro"] ? $row["Sdesc_centro"] : 'Centro sin asignar';
            $sub_array[] = $row["Cdes_zona"] ? $row["Cdes_zona"] : 'Zona sin asignar';
            $sub_array[] = $row["Dfech_ubi"];
            $sub_array[] = $row["Nom_usu_crea"];
            $sub_array[] = $row["Rol_crea"];
            $sub_array[] = $row["Nom_usu_mod"] ? $row["Nom_usu_mod"] : 'N/A';
            $sub_array[] = $row["Rol_mod"] ? $row["Rol_mod"] : 'N/A';
            $sub_array[] = $row["Dfech_usu_mod"] ? $row["Dfech_usu_mod"] : 'N/A';
            $data[] = $sub_array;
        }

        $results = [
            "sEcho" => 1,
            "iTotalRecords" => count($data),
            "iTotalDisplayRecords" => count($data),
            "aaData" => $data
        ];
        echo json_encode($results);
        break;

    case "guardar_ubicacion":
        if (empty($_POST["Ccod_serieID"])) {
            // Inserta nueva ubicación
            $ubicacion->insert_ubicacion(
                $_POST["Ccod_SerieID"],
                $_POST["Ccod_centroID"],
                $_POST["Ccod_zonaID"],
                $_SESSION["Ccod_usu"]
            );
        } else {
            // Actualiza ubicación existente
            $ubicacion->insert_ubicacion(
                $_POST["Ccod_SerieID"],
                $_POST["Ccod_centroID"],
                $_POST["Ccod_zonaID"],
                $_SESSION["Ccod_usu"], // Usuario que realiza la modificación
                true
            );
        }
        break;
}
