<?php
require_once("../../config/conexion.php");
// Asegúrate de que la sesión esté iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica si el usuario ha iniciado sesión
if (isset($_SESSION["Ccod_usu"])) {
?>

<!DOCTYPE html>
<html>
<?php require_once("../head/head.php"); ?>
<title>Gestor de Zonas</title>
</head>

<body class="with-side-menu">

    <?php require_once("../header/header.php"); ?>

    <div class="mobile-menu-left-overlay"></div>
    <?php require_once("../nav/nav.php"); ?>

    <div class="page-content">
        <div class="container-fluid">
            <header class="section-header">
                <div class="tbl">
                    <div class="tbl-row">
                        <div class="tbl-cell">
                            <h3>Registro de Zonas</h3>
                            <h6>En esta ventana, podrás visualizar, registrar, actualizar y asignar las zonas en planta.</h6>
                            <p></p>
                            <ol class="breadcrumb breadcrumb-simple">
                                <li><a href="../home/home.php">Inicio</a></li>
                                <li class="active">Registro de Zonas</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </header>
            <div class="box-typical box-typical-padding">
                <table id="zona_tabla" class="display table table-bordered" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th style="width: 5%;">Código de Zona</th>
                            <th style="width: 10%;">Descripción</th>
                            <th style="width: 8%;">Centro</th>
                            <th class="d-none d-sm-table-cell" style="width: 5%;">Estado</th>
                            <th class="text-center" style="width: 5%;">Editar</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>

                <button id="btnnuevo" type="button" class="btn btn-rounded btn-inline btn-primary">Nueva Zona</button>
            </div>
        </div><!--.container-fluid-->
    </div><!--.page-content-->

    <?php require_once("modalmtn.php"); ?>
    <?php require_once("../js/js.php"); ?>

    <script type="text/javascript" src="mtnzona.js"></script>

</body>

</html>
<?php
} else {
    header("Location:" . Conectar::ruta() . "index.php");
}
?>

