var tabla;

function init() {
  $("#centro_form").on("submit", function (e) {
    guardaryeditar(e);
  });
}

$(document).ready(function () {
  tabla = $("#centro_tabla")
    .dataTable({
      aProcessing: true,
      aServerSide: true,
      dom: "Bfrtip",
      buttons: ["copyHtml5", "excelHtml5", "csvHtml5"],
      ajax: {
        url: "../../controladores/centro.php?op=listar",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      responsive: true,
      bInfo: true,
      iDisplayLength: 10,
      order: [[0, "asc"]],
      language: {
        sProcessing: "Procesando...",
        sLengthMenu: "Mostrar _MENU_ registros",
        sZeroRecords: "No se encontraron resultados",
        sEmptyTable: "Ningún dato disponible en esta tabla",
        sInfo:
          "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
        sInfoEmpty: "Mostrando registros del 0 al 0 de un total de 0 registros",
        sInfoFiltered: "(filtrado de un total de _MAX_ registros)",
        sInfoPostFix: "",
        sSearch: "Buscar:",
        sUrl: "",
        sInfoThousands: ",",
        sLoadingRecords: "Cargando...",
        oPaginate: {
          sFirst: "Primero",
          sLast: "Último",
          sNext: "Siguiente",
          sPrevious: "Anterior",
        },
        oAria: {
          sSortAscending:
            ": Activar para ordenar la columna de manera ascendente",
          sSortDescending:
            ": Activar para ordenar la columna de manera descendente",
        },
      },
    })
    .DataTable();
});

function guardaryeditar(e) {
  e.preventDefault();
  var formData = new FormData($("#centro_form")[0]);
  $.ajax({
    url: "../../controladores/centro.php?op=guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (datos) {
      $("#centro_form")[0].reset();
      $("#modalmtncentro").modal("hide");
      tabla.ajax.reload(function () {
        swal({
          title: "Sistema Modular QR",
          text: "Completado.",
          type: "success",
          confirmButtonClass: "btn-success",
        });
      });
    },
    error: function (xhr, ajaxOptions, thrownError) {
      console.log(xhr.responseText);
    },
  });
}

function editar(Ccod_centroID) {
  $.post(
    "../../controladores/centro.php?op=mostrar",
    { Ccod_centroID: Ccod_centroID },
    function (data) {
      data = JSON.parse(data);
      $("#Ccod_centroID").val(data.Ccod_centroID);
      $("#Ccod_centro").val(data.Ccod_centro);
      $("#Sdesc_centro").val(data.Sdesc_centro);
    }
  );
  $("#mdltitulo").html("Editar centro");
  $("#modalmtncentro").modal("show");
}

$(document).on("click", "#btnnuevo", function () {
  $("#mdltitulo").html("Nuevo centro");
  $("#modalmtncentro").modal("show");
  $("#centro_form")[0].reset();
  $("#Ccod_centroID").val("");
});

init();
