<?php
require_once("../../config/conexion.php");
require_once("../../modelos/Activo.php");
require_once("../../config/config.php");  // Incluyendo config.php

if (isset($_GET["Ccod_serieID"])) {
    $activo = new Activo();
    $datos = $activo->get_activo_detalle($_GET["Ccod_serieID"]);

    if (is_array($datos) && count($datos) > 0) {
        $activo_data = $datos;
    } else {
        header("Location: listado_activos.php");
        exit();
    }
} else {
    header("Location: listado_activos.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detalle del Activo</title>
    <?php require_once("../head/head.php"); ?>

    <script>
        var base_url = "<?php echo $base_url; ?>";
    </script>
</head>

<body>
    <div class="page-content">
        <div class="container-fluid">
            <section class="box-typical box-typical-padding">
                <header class="box-typical-header">
                    <h3>Detalle del Activo</h3>
                </header>
                <div class="box-typical-body">
                    <div class="form-group">
                        <label>Número de serie:</label>
                        <p><?= $activo_data["Ccod_serie"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Descripción:</label>
                        <p><?= $activo_data["Cdesc_Seri"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Clasificación:</label>
                        <p><?= $activo_data["Ccod_tipo_act"] ?> / <?= $activo_data["Cdes_tipo_act"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Especificaciones Técnicas:</label>
                        <div class="proj-page-attach">
                            <i class="font-icon font-icon-pdf"></i>
                            <p class="name"><?= basename($activo_data["Cruta_act"]) ?></p>
                            <p>
                                <a href="../../<?= $activo_data["Cruta_act"] ?>" target="_blank">Ver</a>
                                <a href="../../<?= $activo_data["Cruta_act"] ?>" download>Descargar</a>
                            </p>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Cliente (RUC):</label>
                        <p><?= !empty($activo_data["RUC_clie"]) ? $activo_data["RUC_clie"] : "Cliente no asignado" ?></p>
                    </div>
                    <div class="form-group">
                        <label>Material:</label>
                        <p><?= $activo_data["Cdescrip"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Estado:</label>
                        <p><?= $activo_data["Edescrip"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Centro:</label>
                        <p><?= !empty($activo_data["Sdesc_centro"]) ? $activo_data["Sdesc_centro"] : "Fuera de planta" ?></p>
                    </div>
                    <div class="form-group">
                        <label>Zona:</label>
                        <p><?= !empty($activo_data["Cdes_zona"]) ? $activo_data["Cdes_zona"] : "Fuera de planta" ?></p>
                    </div>
                    <div class="form-group">
                        <label>Último Ret.:</label>
                        <p><?= $activo_data["Dult_ret"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Último Desp.:</label>
                        <p><?= $activo_data["Dult_desp"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Último Mnt.:</label>
                        <p><?= $activo_data["Dult_mnt"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Última Rep.:</label>
                        <p><?= $activo_data["Dult_rep"] ?></p>
                    </div>
                    <div class="form-group">
                        <label>Antiguedad:</label>
                        <p><?= $activo_data["Stiem_ant"] ?></p>
                    </div>

                    <!-- Repositorios de imágenes -->
                    <div class="form-group">
                        <label>Fotos Interior/Exterior:</label>
                        <div id="gallery-interior-exterior" class="gallery-grid"></div>
                    </div>

                    <div class="form-group">
                        <label>Pruebas Técnicas:</label>
                        <div id="gallery-pruebas-tecnicas" class="gallery-grid"></div>
                    </div>

                    <div class="form-group">
                        <label>Devoluciones:</label>
                        <div id="gallery-devolucion" class="gallery-grid"></div>
                    </div>
                    <div class="form-group">
                        <label>Imagen QR:</label>
                        <div id="gallery-imagen-qr" class="gallery-grid"></div>
                    </div>

                    <a href="index.php" class="btn btn-secondary">Regresar</a>
                </div>
            </section>
        </div>
    </div>
    <?php require_once("../js/js.php"); ?>
    <script>
        var activoID = <?= json_encode($_GET["Ccod_serieID"]); ?>;

        function cargarGaleria(categoria, contenedorID, activoID) {
            $.get("../../controladores/activo.php?op=listar_anexos&C_categ=" + categoria + "&Ccod_serieID=" + activoID, function(data) {
                var anexos = JSON.parse(data);
                var gallery = $("#" + contenedorID).empty();
                $.each(anexos, function(index, anexo) {
                    var rutaImagen = base_url + anexo.Cruta_hist.replace("../", "");
                    gallery.append(
                        `<div class="gallery-col">
                            <article class="gallery-item">
                                <img class="gallery-picture" src="${rutaImagen}" alt="${anexo.Cnomb_arch}" height="158">
                                <div class="gallery-hover-layout">
                                    <div class="gallery-hover-layout-in">
                                        <p class="gallery-item-title">${anexo.Cnomb_arch}</p>
                                        <p>${new Date(anexo.Dfech_crea).toLocaleDateString()}</p>
                                        <button class="btn btn-warning btn-view-full" onclick="window.open('${rutaImagen}', '_blank')">Ver en tamaño completo</button>
                                    </div>
                                </div>
                            </article>
                        </div><!--.gallery-col-->`
                    );
                });
            });
        }

        $(document).ready(function() {
            cargarGaleria('interior_exterior', 'gallery-interior-exterior', activoID);
            cargarGaleria('pruebas_tecnicas', 'gallery-pruebas-tecnicas', activoID);
            cargarGaleria('devolucion', 'gallery-devolucion', activoID);
            cargarGaleria('Imagen QR', 'gallery-imagen-qr', activoID);
        });
    </script>
</body>

</html>