<?php
class Zona extends Conectar
{
    public function get_zona()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT 
                    zona.Ccod_zonaID, 
                    zona.Ccod_zona, 
                    zona.Cdes_zona, 
                    zona.Cactivo, 
                    centro.Ccod_centro, 
                    centro.Sdesc_centro 
                FROM 
                    zona 
                INNER JOIN 
                    centro 
                ON 
                    zona.Ccod_centroID = centro.Ccod_centroID";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function get_zona_id($Ccod_zonaID)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM zona WHERE Ccod_zonaID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->execute([$Ccod_zonaID]);
        return $stmt->fetch();
    }

    public function get_centros()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT Ccod_centroID, Ccod_centro, Sdesc_centro FROM centro";
        $stmt = $conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function insert_zona($Ccod_centroID, $Ccod_zona, $Cdes_zona, $Cactivo)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "INSERT INTO zona (Ccod_centroID, Ccod_zona, Cdes_zona, Cactivo) 
                VALUES (?, ?, ?, ?)";
        $stmt = $conectar->prepare($sql);
        $stmt->execute([$Ccod_centroID, $Ccod_zona, $Cdes_zona, $Cactivo]);
        return true;
    }

    public function update_zona($Ccod_zonaID, $Ccod_centroID, $Ccod_zona, $Cdes_zona, $Cactivo)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "UPDATE zona 
                SET Ccod_centroID = ?, Ccod_zona = ?, Cdes_zona = ?, Cactivo = ? 
                WHERE Ccod_zonaID = ?";
        $stmt = $conectar->prepare($sql);
        $stmt->execute([$Ccod_centroID, $Ccod_zona, $Cdes_zona, $Cactivo, $Ccod_zonaID]);
        return true;
    }
}
?>
