<?php
class ActivoCliente extends Conectar
{
    private $conectar;

    public function __construct()
    {
        $this->conectar = parent::conexion();
        parent::set_names();
    }

    // Método para obtener los activos
    public function get_activos()
    {
        $sql = "SELECT Ccod_serieID, Ccod_serie, Cdesc_Seri FROM activo";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Método para obtener detalles del activo
    public function get_activo_detalle($Ccod_serieID)
    {
        $sql = "SELECT a.Ccod_serie, 
                       a.Cdesc_Seri, 
                       IFNULL(c.RUC_clie, 'Cliente no asignado') AS RUC_clie, 
                       ta.Cruta_act
                FROM activo a
                LEFT JOIN cliente c ON a.Ccod_clieID = c.Ccod_clieID
                INNER JOIN tipo_activo ta ON a.Ccod_tipo_act = ta.Ccod_tipo_actID
                WHERE a.Ccod_serieID = ?";
        $stmt = $this->conectar->prepare($sql);
        $stmt->execute([$Ccod_serieID]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            $result['Cruta_act'] = str_replace('../', '', $result['Cruta_act']);
        }

        return $result;
    }
}
function generar_qr_con_texto($Ccod_serie, $url)
{
    // Directorio para almacenar el QR generado
    $tempDir = "../publico/qrgenerado/";

    // Nombre del archivo QR
    $filename = $tempDir . $Ccod_serie . ".png";

    // Generar el QR con un tamaño de módulo ajustado para un tamaño cercano a 230x230
    $qrSize = 3; // Ajustar el tamaño del módulo
    QRcode::png($url, $filename, QR_ECLEVEL_L, $qrSize, 2);

    // Cargar la imagen del QR generado
    $qrImage = imagecreatefrompng($filename);

    // Ajustar el tamaño de la imagen del QR a 230x230 píxeles
    $desiredSize = 260;
    $resizedQrImage = imagecreatetruecolor($desiredSize, $desiredSize);
    imagecopyresampled($resizedQrImage, $qrImage, 0, 0, 0, 0, $desiredSize, $desiredSize, imagesx($qrImage), imagesy($qrImage));

    // Definir la altura adicional para el texto vertical
    $textWidth = 50;
    $finalImageWidth = $desiredSize + $textWidth;

    // Crear una nueva imagen para el QR y el texto
    $finalImage = imagecreatetruecolor($finalImageWidth, $desiredSize);

    // Definir colores para la nueva imagen (fondo blanco y texto negro)
    $white = imagecolorallocate($finalImage, 255, 255, 255);
    $black = imagecolorallocate($finalImage, 0, 0, 0);

    // Rellenar el fondo con color blanco
    imagefilledrectangle($finalImage, 0, 0, $finalImageWidth, $desiredSize, $white);

    // Copiar la imagen QR en la nueva imagen
    imagecopy($finalImage, $resizedQrImage, 50, 0, 0, 0, $desiredSize, $desiredSize);

    // Definir la fuente y el tamaño para el texto
    $fontFile = __DIR__ . '/../publico/fonts/AidaSerif.ttf'; // Asegúrate de tener una fuente ttf en la ruta correcta
    if (!file_exists($fontFile)) {
        die("Error: No se encuentra la fuente en la ruta especificada.");
    }

    $fontSize = 23;
    $xPosition = 20;
    $yPosition = 60;

    // Dibujar cada letra de forma vertical
    for ($i = 0; $i < strlen($Ccod_serie); $i++) {
        imagettftext($finalImage, $fontSize, 0, $xPosition, $yPosition, $black, $fontFile, $Ccod_serie[$i]);
        $yPosition += $fontSize + 5;
    }

    // Guardar la nueva imagen con el texto incluido
    imagepng($finalImage, $filename);

    // Liberar memoria
    imagedestroy($qrImage);
    imagedestroy($resizedQrImage);
    imagedestroy($finalImage);

    return $filename; // Retorna la ruta de la nueva imagen con el texto
}

