<?php
require_once("../config/conexion.php");
require_once("../modelos/Graficos.php");

header('Content-Type: application/json');

$graficos = new Graficos();

if (isset($_GET["op"])) {
    switch ($_GET["op"]) {
        case "total_activos":
            $data = $graficos->getTotalActivos();
            echo json_encode($data);
            break;

        case "activos_sin_cliente":
            $data = $graficos->getActivosSinCliente();
            echo json_encode($data);
            break;

        case "activos_en_mantenimiento":
            $data = $graficos->getActivosEnMantenimiento();
            echo json_encode($data);
            break;

        case "activos_en_centro":
            $data = $graficos->getActivosEnCentro();
            echo json_encode($data);
            break;

        case "activos_por_estado":
            $data = $graficos->getActivosPorEstado();
            echo json_encode($data);
            break;

        case "activos_por_centro":
            $data = $graficos->getActivosPorCentro();
            echo json_encode($data);
            break;

        default:
            echo json_encode(["error" => "Operación no válida."]);
            break;
    }
} else {
    echo json_encode(["error" => "No se proporcionó ninguna operación."]);
}

