<?php
require_once("../config/conexion.php");
require_once("../config/config.php");
require_once("../modelos/ActivoCliente.php");
require_once("../publico/phpqrcode/phpqrcode.php");

$activoCliente = new ActivoCliente();

switch ($_GET["op"]) {
    case "listar_activos":
        $datos = $activoCliente->get_activos();
        echo json_encode($datos);
        break;

    case "mostrar_activo":
        if (isset($_GET["Ccod_serieID"])) {
            $datos = $activoCliente->get_activo_detalle($_GET["Ccod_serieID"]);
            echo json_encode($datos);
        }
        break;

    case "verificar_qr":
        if (isset($_POST['Ccod_serie'])) {
            $Ccod_serie = $_POST['Ccod_serie'];
            $filename = "../publico/qrgenerado/" . $Ccod_serie . ".png";

            if (file_exists($filename)) {
                $public_path = $base_url . "publico/qrgenerado/" . $Ccod_serie . ".png";
                echo json_encode(["status" => "exists", "qr_path" => $public_path, "filename" => $Ccod_serie . ".png"]);
            } else {
                echo json_encode(["status" => "not_exists"]);
            }
        }
        break;

    case "generar_qr":
        if (isset($_POST['url']) && isset($_POST['Ccod_serie'])) {
            $url = $_POST['url'];
            $Ccod_serie = $_POST['Ccod_serie'];

            // Generar el QR con el Ccod_serie como texto vertical
            $qrWithTextPath = generar_qr_con_texto($Ccod_serie, $url);

            // Verificar si el archivo se gener
            if (file_exists($qrWithTextPath)) {
                $public_path = $base_url . "publico/qrgenerado/" . $Ccod_serie . ".png";
                echo json_encode(["status" => "success", "qr_path" => $public_path, "filename" => $Ccod_serie . "_with_text.png"]);
            } else {
                echo json_encode(["status" => "error", "message" => "No se pudo generar el QR."]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "No se proporcion la URL o Ccod_serie."]);
        }
        break;
}

